
Declare Sub VGA_Load ( VGA_Table ( Any ) As String, Filename As String = "VGA Table" )

ReDim Shared As String VGA_Table ( Any )

Sub VGA_Load ( VGA_Table ( Any ) As String, Filename As String = "VGA Table" )
	Erase VGA_Table

	If Not Is_File ( ".\" & ProjectSpace & "\Assets\" & Filename & ".seq" ) Then
		Exit Sub
	End If

	Dim As Long FileMode = FreeFile

	If FileMode = 0 Then
		Close #FileMode
		Exit Sub
	End If

	IF Open ( ".\" & ProjectSpace & "\Assets\" & Filename & ".seq" For Input As #FileMode ) Then
		Close #FileMode
		FileMode = 0
		Exit Sub
	End If

	Do While Not Eof ( Filemode )
		
		If LBound ( VGA_Table ) = 0 AndAlso UBound ( VGA_Table ) = - 1 Then
			ReDim VGA_Table ( 0 To 0 )
		Else
			ReDim Preserve VGA_Table ( 0 To UBound ( VGA_Table ) + 1 )
		End IF
		
		Input #Filemode, VGA_Table ( UBound ( VGA_Table ) )
	
	Loop
	
	Close #Filemode
	
	Exit Sub
	
End Sub

Declare Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt

Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt

	Select Case Index

	Case 0 To 255

		VGA_Lookup = ValInt ( VGA_Table ( Index ) )

		Exit Function

	Case Else

		VGA_Lookup = ValInt ( VGA_Table ( 0 ) )

	End Select

End Function

